<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage libraries
* @filesource
*//** */
 

/**
* @package direct-as-a-service
* @subpackage libraries
*/
class Auth {
	private $CI;
	private $CAC_errors;
	private $PIV_errors;
	public function __construct() {
		$this->CI =& get_instance();
		$this->CI->load->library(array('session','encrypt','eventlog'));
		$this->CI->load->model('loginsmodel');
		$this->CI->load->helper('cert');
	}
	
	public function perform_auth() {
		//determine which authentication method to use
		if(isset($_SERVER['HTTP_CERT'])) {
			$cert = clean_cert_string($_SERVER['HTTP_CERT']);
			$parsed_cert = openssl_x509_parse($cert);
			if(USE_CAC_AUTH && USE_PIV_AUTH) {
				if(!$this->CACAuth()) {
					if(!$this->PIVAuth()) {
						$errors = $this->CAC_errors;
						$this->CI->eventlog->create_login($this->CI->session->userdata('session_id'),$_SERVER['HTTP_X_REAL_IP'],$errors['time'],$errors['success'],$errors['message'],$errors['org_id']);
						$errors = $this->PIV_errors;
						$this->CI->eventlog->create_login($this->CI->session->userdata('session_id'),$_SERVER['HTTP_X_REAL_IP'],$errors['time'],$errors['success'],$errors['message'],$errors['org_id']);
					}
				}
				else { return TRUE; }
			}
			else if(USE_CAC_AUTH) {
				if(!$this->CACAuth()) {
					$errors = $this->CAC_errors;
					$this->CI->eventlog->create_login($this->CI->session->userdata('session_id'),$_SERVER['HTTP_X_REAL_IP'],$errors['time'],$errors['success'],$errors['message'],$errors['org_id']);
				}
				else { return TRUE; }
			}
			else if(USE_PIV_AUTH) {
				if(!$this->PIVAuth()) {
					$errors = $this->PIV_errors;
					$this->CI->eventlog->create_login($this->CI->session->userdata('session_id'),$_SERVER['HTTP_X_REAL_IP'],$errors['time'],$errors['success'],$errors['message'],$errors['org_id']);
				}
				else { return TRUE; }
			}
			else {
				//no authentication mechanism configured
			}
			return FALSE;
		}
		else {
			//TO-DO: If non-certificate based authentication mechanism is developed, it should be called here instead of recording error
			$this->CI->eventlog->create_login($this->CI->session->userdata('session_id'), element('HTTP_X_REAL_IP', $_SERVER), time(),0,'Error: No certificate sent',0);
			return FALSE;
		}
	}
	
	/* This function performs CAC authentication by pulling the client certificate passed from nginx
	 * and parsing it out the subject to identify the user. The user is identified by their EDIPI, which is
	 * stored in session (encrypted for security) for use in looking up permissions. If the certificate is not expired,
	 * the auth is considered a success because nginx handles the CRL checking and validation that it is a valid CAC certificate.
	 * Returns TRUE on success, FALSE on failure.
	 */
	private function CACauth() {
		if(!isset($_SERVER['HTTP_CERT'])) { return FALSE;} //if no cert is provided, CAC auth fails
		$cert = clean_cert_string($_SERVER['HTTP_CERT']);
		$parsed_cert = openssl_x509_parse($cert);
		
		$cn_arr = explode(".",$parsed_cert['subject']['CN']);
		$last = $cn_arr[0];
		$first = $cn_arr[1];
		$middle = '';
		$suffix = '';
		//parse the subject of the certificate to get first name, last name, middle initial (if present), and suffix (if present), as well as EDIPI
		if(count($cn_arr) == 4) {
			//check if its suffix or last name
			if(strtolower($cn_arr[2]) == 'jr' || strtolower($cn_arr[2]) == 'sr' || is_roman_numeric($cn_arr[2])) {
				$suffix = $cn_arr[2];
				$middle = '';
			}
			else { 
				$middle = $cn_arr[2];
				$suffix = '';
			}
			$edipi = $cn_arr[3];
		}
		else if(count($cn_arr) == 5) {
			$middle = $cn_arr[2];
			$suffix = $cn_arr[3];
			$edipi = $cn_arr[4];
		}
		else { $edipi = $cn_arr[2]; }
		
		//get email address if available
		if(isset($parsed_cert['extensions']['subjectAltName'])) {
			$alt_name_arr = explode(',',$parsed_cert['extensions']['subjectAltName']);
			$email = '';
			foreach($alt_name_arr as $alt_name) {
				if(strpos($alt_name,'email') !== FALSE) { $email = str_replace('email:','',$alt_name); }
			}
		}
		else { $email = ''; }

		//if EDIPI is not numeric something has gone wrong, so return FALSE
		if(is_numeric($edipi)) {
			//if they have a valid non-expired CAC, they can log in to see documentation
			if(time() >= $parsed_cert['validFrom_time_t'] && time() <= $parsed_cert['validTo_time_t']) {
				$this->CI->session->set_userdata('is_loggedin','true');
				//put EDIPI in session as user id and encrypt for extra security
				$this->CI->session->set_userdata('user_id',$this->CI->encrypt->encode($edipi));
				$user_info = array(
					'first_name' => $first,
					'middle_name' => $middle,
					'last_name' => $last,
					'suffix' => $suffix,
					'email' => $email,
				);
				$this->CI->session->set_userdata('user_info',$user_info);
				$this->CI->eventlog->create_login($this->CI->session->userdata('session_id'),$_SERVER['HTTP_X_REAL_IP'],time(),1,'Success',$edipi);
				unset($this->CAC_errors);
				return TRUE;
			}
			else {
				$this->CAC_errors = array('time'=>time(),'success'=>0,'message'=>'Error: CAC expired','org_id'=>$edipi);
			}
		}
		else {
			$this->CAC_errors = array('time'=>time(),'success'=>0,'message'=>'Error: EDIPI is not numeric','org_id'=>0);
		}
		return FALSE;
	}
	
	public function CAC_errors() {
		return $this->CAC_errors;
	}
	
	/* This function performs PIV authentication by pulling the client certificate passed from nginx
	 * and parsing it out the subject to identify the user. The user is identified by their PIV ID, which is
	 * stored in session (encrypted for security) for use in looking up permissions. If the certificate is not expired,
	 * the auth is considered a success because nginx handles the CRL checking and validation that it is a valid PIV certificate.
	 * Returns TRUE on success, FALSE on failure.
	 */
	private function PIVauth() {
		if(!isset($_SERVER['HTTP_CERT'])) { return FALSE;} //if no cert is provided, PIV auth fails
		$cert = clean_cert_string($_SERVER['HTTP_CERT']);
		$parsed_cert = openssl_x509_parse($cert);
		$cn_arr = explode(' ',trim($parsed_cert['subject']['CN']));
		$first = $cn_arr[0];
		$middle = $suffix = '';
		if(count($cn_arr) == 4) {
			if(preg_match('/\(.*?\)/',$cn_arr[3]) === 0) { //if there is not something appended in parentheses after the piv id
				//check if its suffix or last name
				if(strtolower($cn_arr[2]) == 'jr' || strtolower($cn_arr[2]) == 'sr' || is_roman_numeric($cn_arr[2])) {
					$suffix = $cn_arr[2];
					$last = $cn_arr[1];
				}
				else {
					$middle = $cn_arr[1];
					$last = $cn_arr[2];
					$suffix = '';
				}
				$piv_id = $cn_arr[3];
			}
			else {
				$last = $cn_arr[1];
				$piv_id = $cn_arr[2];
			}
		}
		else if(count($cn_arr) == 5) {
			if(preg_match('/\(.*?\)/',$cn_arr[4]) === 0) { //if there is not something appended in parentheses after the piv id
				$middle = $cn_arr[1];
				$last = $cn_arr[2];
				$suffix = $cn_arr[3];
				$piv_id = $cn_arr[4];
			}
			else {
				//check if its suffix or last name
				if(strtolower($cn_arr[2]) == 'jr' || strtolower($cn_arr[2]) == 'sr' || is_roman_numeric($cn_arr[2])) {
					$suffix = $cn_arr[2];
					$last = $cn_arr[1];
				}
				else {
					$middle = $cn_arr[1];
					$last = $cn_arr[2];
					$suffix = '';
				}
				$piv_id = $cn_arr[3];
			}
		}
		else if(count($cn_arr) == 3) {
			$last = $cn_arr[1];
			$piv_id = $cn_arr[2];
		}

		//get email address if available
		$email = '';
		if(isset($parsed_cert['extensions']['subjectAltName'])) {
			$alt_name_arr = explode(',',$parsed_cert['extensions']['subjectAltName']);
			$email = '';
			foreach($alt_name_arr as $alt_name) {
				if(strpos($alt_name,'email') !== FALSE) { $email = str_replace('email:','',$alt_name); }
			}
		}
		//if that didn't do it for emaik, let's try the UID field of the subject (store uid as well for use in creating username)
		
		if(isset($parsed_cert['subject']['UID'])) {
			if((!isset($email) || strlen($email) <= 0)) {
				$email = $parsed_cert['subject']['UID'];
			}
			$uid = $parsed_cert['subject']['UID'];
		}

		//if PIV is not numeric something has gone wrong, so return FALSE
		if(is_numeric($piv_id)) {
			//if they have a valid non-expired PIV, they can log in to see documentation
			if(time() >= $parsed_cert['validFrom_time_t'] && time() <= $parsed_cert['validTo_time_t']) {
				$this->CI->session->set_userdata('is_loggedin','true');
				//put PIV ID in session as user id and encrypt for extra security
				$this->CI->session->set_userdata('user_id',$this->CI->encrypt->encode($piv_id));
				$user_info = array(
					'first_name' => $first,
					'middle_name' => $middle,
					'last_name' => $last,
					'suffix' => $suffix,
					'email' => $email,
				);
				if(isset($uid)){
					$user_info['uid'] = $uid;
				}
				$this->CI->session->set_userdata('user_info',$user_info);
				$this->CI->eventlog->create_login($this->CI->session->userdata('session_id'),$_SERVER['HTTP_X_REAL_IP'],time(),1,'Success',$piv_id);
				return TRUE;
			}
			else{
				$this->PIV_errors = array('time'=>time(),'success'=>0,'message'=>'Error: PIV expired','org_id'=>$piv_id);
			}
		}
		else {
			$this->PIV_errors = array('time'=>time(),'success'=>0,'message'=>'Error: PIV ID is not numeric','org_id'=>0);
		}
		return FALSE;
	}
	
	public function PIV_errors() {
		return $this->PIV_errors;
	}
}